\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Unul sfânt"
  subtitle = "glasul 8"
  %subsubtitle = "glasurile 8, 1"
  composer =  "arm. după N. Lungu"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOff
  \time 2/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min. Și du -- hu -- lui tău.
  Ți -- e, Doam -- ne. A -- min.
  
  U -- nul Sfânt, u -- nul Domn I -- i -- sus Hris -- tos, __
  În -- tru mă -- ri -- rea lui Dum -- ne -- zeu Ta -- tăl. A -- min. __
}

menWords = \womenWords

sopMusic = \relative c'' {
  c2^\f c \bar "||"
  \partial 4 f,4^\mf 
  a2 g4 g f2 \bar"||"
  c'4^\accent c g^\<( a b^\> g) f4. h8\rest\! \bar"||"
  c2^\f c \bar "||" \break
  \key c \major
  \mark "         Unul Sfânt"
  c4^\mf c c2 a4 h c( h8[ a]) g4 g a h c2( c4) \breathe
  g4 c d e2^\f d4 c h a h( c) h( a) g2 \breathe
  a2( h) c2( c4) h4\rest \bar"||" \break
  \bar "|."
}

altMusic = \relative c'' {
  a2 a f4 f2 e4 e f2
  a4 a g( f d e) f4. h8\rest a2 a
  
  c4 c c2 a4 g c( h8[ a]) g4 g f f e2( e4)
  g4 g h c2 h4 a g fis g( a) h( a) g2 f2( f) e2( e4) h'4\rest
}

tenorMusic = \relative c {
  f2 a a4 c2 b4 b a2
  c4 c c2( b) a4. d,8\rest c'2 c
  c4 c c2 c4 d es2 d4 d c c c2( c4)
  c4 c d e2 d4 c d d d( c) h( a) g2
  a2( h4 a) g2( g4) d4\rest
}

bassMusic = \relative c {
  f2 f f4 f2 c4 c f2
  f4 f e( f b, c) <f f,>4. d8\rest f2 f 
  \key c \major
  c'4 c c2 a4 g c( h8[ a]) g4 g f d c2( c4) 
  g'4 g g g2 g4 a g d g2 h4( a) g2 f( d) c2( c4) d4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}